#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = 2e5 + 3;
const int inf = 1e9;
int n;

struct point {
  ll x, y;
};
map<pair<ll, ll>, int> mp;
vector<point> trouglovi[N];
ll ans_trouglovi[N];
enum orijentacija {Clockwise, Collinear, CounterClockwise};

orijentacija orijentisi(point a, point b, point c) {
    ll d = (b.y - a.y)*(c.x - a.x) - (b.x - a.x)*(c.y - a.y);
    if (d == 0) return Collinear;
    if (d > 0) return Clockwise;
    return CounterClockwise;
}

bool on_segment(point a, point m, point p) {
    if (a.x >= min(p.x, m.x) && a.x <= max(p.x, m.x) &&
        a.y >= min(p.y, m.y) && a.y <= max(p.y, m.y))
        return true;
    return false;
}

ll area(point a, point b, point c) {
    ll det = abs(a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y)) / 2;
    return det;
}

ll povrsina(const vector<point>& temena) {
    point t = temena[0];
    ll ans = 0;
    for (int i = 2; i < (int)temena.size(); i++) {
        ans += area(t, temena[i-1], temena[i]);
    }
    return ans;
}

bool TackaUTrouglu(point p, point a, point b, point c) {
    orijentacija o1 = orijentisi(a, b, p);
    orijentacija o2 = orijentisi(b, c, p);
    orijentacija o3 = orijentisi(c, a, p);
    if (o1 == Collinear && on_segment(p, a, b)) return true;
    if (o2 == Collinear && on_segment(p, b, c)) return true;
    if (o3 == Collinear && on_segment(p, c, a)) return true;
    return (o1 == o2 && o2 == o3);
}

void pripadaTrouglu(const vector<point>& temena, point tac) { //menjaj const temena po potrebi
    int sz = temena.size();
    point a = temena[0];
    int l = 1, r = sz - 1;
    if (TackaUTrouglu(tac, temena[0], temena[l], temena[r])) {
        trouglovi[0].push_back(tac);
    }
    while (l + 1 < r) {
        int mid = (l + r) / 2;
        point b = temena[mid];
        orijentacija o = orijentisi(a, b, tac);
        if (o == Collinear) {
            return;
        }
        if (o == Clockwise)
            r = mid;
        else
            l = mid;
    }
    if (TackaUTrouglu(tac, temena[l], temena[l-1], temena[r])) {
        trouglovi[l].push_back(tac);
    }
    if (TackaUTrouglu(tac, temena[l], temena[r], temena[(r+1)%sz])) {
        trouglovi[r].push_back(tac);
    }
}

vector<point> GrahamScan(vector<point> tacke) {
    int n = tacke.size();
    vector<pair<double, int>> ugao;
    sort(tacke.begin(), tacke.end(), [](const point& a, const point& b) {
		return (a.y < b.y || (a.y == b.y && a.x < b.x));});

    for (int i = 1; i < n; i++) {
        double dy = double(tacke[i].y) - tacke[0].y;
        double dx = double(tacke[i].x) - tacke[0].x;
        double teta = atan2(dy, dx);
        ugao.push_back({teta, i});
    }
    sort(ugao.begin(), ugao.end());

    stack<point> stek;
    stek.push(tacke[0]);
    stek.push(tacke[ugao[0].second]);

    for (int in = 1; in < ugao.size(); in++) {
        double teta; int i;
        tie(teta, i) = ugao[in];

        while (stek.size() >= 2) {
            point b = stek.top(); stek.pop();
            point a = stek.top(); stek.push(b);
            point c = tacke[i];
            orijentacija o1 = orijentisi(a, b, c);
            if (o1 != CounterClockwise)
                stek.pop();
            else
                break;
        }
        stek.push(tacke[i]);
    }
    vector<point> res;
    while (!stek.empty()) {
        res.push_back(stek.top());
        stek.pop();
    }
    reverse(res.begin(), res.end());
    /// vraca tacke obrnuto od kazaljke na satu

    return res;
}



void solve() {
    cin >> n;
    vector<point> tac(n);
    for (int i = 0; i < n; i++) {
        ll xx, yy; cin >> xx >> yy;
        tac[i].x = xx; tac[i].y = yy;
    }
    vector<point> grah = GrahamScan(tac), unutar;
    int szgrah = (int)grah.size();
    for (auto [xx, yy] : grah) {
        mp[make_pair(xx, yy)]++;
    }
    for (auto [xx, yy] : tac) {
        if (mp[{xx, yy}] == 0)
            unutar.push_back({xx, yy});
    }
    ll P = povrsina(grah);
    ll ans = P;
    for (int i = 0; i < (int)grah.size(); i++) {
        int l = (i-1+szgrah)%szgrah, r = (i+1)%szgrah;
        ans_trouglovi[i] = P - area(grah[l], grah[i], grah[r]);
        trouglovi[i].push_back(grah[l]);
        trouglovi[i].push_back(grah[r]);
    }
    for (auto p : unutar) {
        pripadaTrouglu(grah, p);
    }
    for (int i = 0; i < (int)grah.size(); i++) {
        ll cur = povrsina(GrahamScan(trouglovi[i]));
        ans_trouglovi[i] += cur;
        ans = min(ans, ans_trouglovi[i]);
    }

    cout << ans << "\n";
}

signed main() {
    ios::sync_with_stdio(false); cin.tie(0);
	int t=1; //cin >> t;
	while (t--) {
        solve();
	}
}